<?php
// ajax_removebg.php
header('Content-Type: application/json; charset=utf-8');
$CFG = require __DIR__ . '/config.php';

try{
  if (empty($CFG['remove_bg']['enabled']) || ($CFG['remove_bg']['provider'] ?? '') !== 'rembg') {
    throw new Exception('Remove BG tidak diaktifkan.');
  }
  $endpoint = rtrim($CFG['remove_bg']['endpoint'] ?? '', '/');
  if (!$endpoint) throw new Exception('Endpoint rembg kosong.');

  $dataUrl = $_POST['image'] ?? '';
  if (!$dataUrl || !preg_match('#^data:image/(png|jpe?g);base64,#i', $dataUrl)) {
    throw new Exception('Format gambar tidak valid.');
  }
  $bin = base64_decode(preg_replace('#^data:image/[^;]+;base64,#','', $dataUrl));
  if ($bin === false || strlen($bin) > 8*1024*1024) {
    throw new Exception('Gambar kosong atau terlalu besar (>8MB).');
  }

  // kirim ke rembg
  $tmp = tempnam(sys_get_temp_dir(), 'rmbg_');
  file_put_contents($tmp, $bin);
  $ch = curl_init($endpoint);
  $cfile = new CURLFile($tmp, 'image/png', 'photo.png');
  curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => ['file' => $cfile],
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CONNECTTIMEOUT => 10,
    CURLOPT_TIMEOUT => (int)($CFG['remove_bg']['timeout'] ?? 60),
    CURLOPT_SSL_VERIFYPEER => true,
  ]);
  $res = curl_exec($ch);
  $http = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
  $err  = curl_error($ch);
  curl_close($ch);
  @unlink($tmp);

  if ($http !== 200 || $res === false) {
    throw new Exception('HTTP '.$http.' '.($err?:'gagal memproses'));
  }

  echo json_encode(['ok'=>1,'data_url'=>'data:image/png;base64,'.base64_encode($res)]);
}catch(Exception $e){
  echo json_encode(['ok'=>0,'error'=>$e->getMessage()]);
}
