<?php
require __DIR__ . '/koneksi.php';

function quick_crop_34($src,$dst){
  $img=@imagecreatefromstring(file_get_contents($src)); if(!$img) return false;
  $w=imagesx($img); $h=imagesy($img); $r=3/4; $cr=$w/$h;
  if($cr>$r){ $nw=(int)round($h*$r); $x=(int)(($w-$nw)/2); $y=0; $cw=$nw; $ch=$h; }
  else { $nh=(int)round($w/$r); $x=0; $y=(int)(($h-$nh)/2); $cw=$w; $ch=$nh; }
  $crop=imagecreatetruecolor($cw,$ch);
  imagecopy($crop,$img,0,0,$x,$y,$cw,$ch);
  imagepng($crop,$dst,9); imagedestroy($crop); imagedestroy($img); return true;
}

$id = (int)($_GET['id'] ?? $_POST['id'] ?? 0);
if(!$id){ header('Location: list_mahasiswa.php'); exit; }

if ($_SERVER['REQUEST_METHOD']==='POST'){
  $nama=mysqli_real_escape_string($conn,$_POST['nama']??'');
  $jenjang=mysqli_real_escape_string($conn,$_POST['jenjang']??'');
  $jurusan=mysqli_real_escape_string($conn,$_POST['jurusan']??'');
  $angkatan=mysqli_real_escape_string($conn,$_POST['angkatan']??'');
  $nim=preg_replace('/\D+/','',$_POST['nim']??'');

  $conn->query("UPDATE mahasiswa SET 
    nama='$nama', jenjang='$jenjang', jurusan='$jurusan', angkatan='$angkatan', nim='$nim'
    WHERE id=$id");

  if (!empty($_FILES['foto']['tmp_name'])){
    $procDir=__DIR__.'/uploads/processed'; if(!is_dir($procDir)) @mkdir($procDir,0775,true);
    $dst=$procDir.'/'.preg_replace('/\W+/','',$nim).'.png';
    quick_crop_34($_FILES['foto']['tmp_name'],$dst);
    $rel='uploads/processed/'.preg_replace('/\W+/','',$nim).'.png';
    $conn->query("UPDATE mahasiswa SET foto='$rel' WHERE id=$id");
  }
  header('Location: list_mahasiswa.php'); exit;
}

$rw = $conn->query("SELECT * FROM mahasiswa WHERE id=$id")->fetch_assoc();
if(!$rw){ header('Location: list_mahasiswa.php'); exit; }
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Edit Mahasiswa</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
  <h3 class="mb-3">Edit Mahasiswa</h3>
  <form class="card p-3 shadow-sm" method="post" enctype="multipart/form-data">
    <input type="hidden" name="id" value="<?= (int)$rw['id'] ?>">
    <div class="mb-2"><label class="form-label">Nama</label><input class="form-control" name="nama" value="<?= htmlspecialchars($rw['nama']) ?>"></div>
    <div class="row g-2">
      <div class="col-md-3"><label class="form-label">Jenjang</label><input class="form-control" name="jenjang" value="<?= htmlspecialchars($rw['jenjang']) ?>"></div>
      <div class="col-md-5"><label class="form-label">Jurusan</label><input class="form-control" name="jurusan" value="<?= htmlspecialchars($rw['jurusan']) ?>"></div>
      <div class="col-md-2"><label class="form-label">Angkatan</label><input class="form-control" name="angkatan" value="<?= htmlspecialchars($rw['angkatan']) ?>"></div>
      <div class="col-md-2"><label class="form-label">NIM</label><input class="form-control" name="nim" value="<?= htmlspecialchars($rw['nim']) ?>"></div>
    </div>
    <div class="mt-2">
      <label class="form-label">Ganti Foto (opsional)</label>
      <input class="form-control" type="file" name="foto" accept="image/*">
      <?php if(!empty($rw['foto'])): ?><div class="mt-2"><img src="<?= htmlspecialchars($rw['foto']) ?>" style="height:120px;border-radius:8px"></div><?php endif; ?>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary" type="submit">Simpan</button>
      <a class="btn btn-light" href="list_mahasiswa.php">Kembali</a>
    </div>
  </form>
</div>
</body>
</html>
