<?php
$CFG = require __DIR__ . '/config.php';
$rembgOn   = !empty(($CFG['remove_bg']['enabled'] ?? false));
$rembgName = (($CFG['remove_bg']['provider'] ?? 'rembg') === 'rembg') ? 'Server Rembg' : 'remove.bg';
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Form KTM 2026</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/cropperjs@1.6.2/dist/cropper.min.css" rel="stylesheet">
<style>
  .photo-preview{ width:120px; height:180px; background:#f1f1f1; border-radius:8px; display:flex; align-items:center; justify-content:center; overflow:hidden; }
  .photo-preview img{ width:100%; height:100%; object-fit:cover; }

  /* overlay submit */
  #busyOverlay{ position:fixed; inset:0; background:rgba(0,0,0,.45); display:none; align-items:center; justify-content:center; z-index:2000; }
  #busyOverlay .box{ background:#fff; padding:18px 22px; border-radius:10px; box-shadow:0 8px 30px rgba(0,0,0,.25); display:flex; gap:12px; align-items:center; }
  .spinner{ width:22px; height:22px; border:3px solid #d0d0d0; border-top-color:#0d6efd; border-radius:50%; animation:spin 1s linear infinite; }
  @keyframes spin{ to{ transform:rotate(360deg); } }
</style>
</head>
<body class="bg-light">

<div class="container py-4">
    <div class="navbar-brand d-flex align-items-center gap-2" href="#top">
    <img src="assets/img/logo_kampus.png" style="width:60px;">
    <h3 class="mb-3">Form KTM 2026</h3>
    <span><img src="assets/img/logo_ibitek.png" style="width:45px;"></span></div>
    
    <hr>

  <form id="ktmForm" class="card shadow-sm" method="post" action="generate.php" enctype="multipart/form-data">
    <div class="card-body">
      <div class="mb-3">
        <label class="form-label">Nama Lengkap</label>
        <input type="text" name="nama" class="form-control" required placeholder="Nama sesuai KTM" oninput="this.value=this.value.toUpperCase()">
      </div>

      <div class="row g-3">
        <div class="col-sm-4">
          <label class="form-label">Jenjang</label>
          <select name="jenjang" class="form-select">
            <option value="S1">S1</option>
            <option value="D3">D3</option>
          </select>
        </div>
        <div class="col-sm-4">
          <label class="form-label">Angkatan</label>
          <input type="text" name="angkatan" class="form-control" value="<?= date('Y') ?>" required>
        </div>
        <div class="col-sm-4">
          <label class="form-label">Program Studi / Jurusan</label>
          <select name="jurusan" class="form-select" required>
            <option>Teknologi Informasi</option>
            <option>Akuntansi</option>
            <option>Manajemen</option>
          </select>
        </div>
      </div>

      <div class="mt-3">
        <label class="form-label">NIM (untuk barcode)</label>
        <input type="text" name="nim" class="form-control" inputmode="numeric" pattern="\d+" placeholder="Hanya angka" required>
      </div>

      <div class="mt-3">
        <label class="form-label d-flex justify-content-between">
          <span>Foto Wajah (rasio 3:4)</span>
          <small class="text-muted">ambil kamera / pilih file</small>
        </label>

        <div class="d-flex align-items-center gap-3">
          <!-- penting: name="foto" sebagai fallback bila user tidak menekan 'Simpan Crop' -->
          <input class="form-control" type="file" id="photoFile" name="foto" accept="image/*" capture="environment">
          <?php if ($rembgOn): ?>
          <div class="form-check ms-2">
            <input class="form-check-input" type="checkbox" id="remove_bg" name="remove_bg" value="1">
            <label class="form-check-label" for="remove_bg">Remove background (<?= htmlspecialchars($rembgName) ?>)</label>
          </div>
          <?php endif; ?>
        </div>

        <div class="d-flex align-items-start gap-3 mt-2">
          <div class="photo-preview" id="photoPreview" style="width:100%;"><span class="text-muted small">Belum ada foto</span></div>

          <div class="d-flex flex-column gap-2" style="width:100%;">
            <?php if ($rembgOn): ?>
              <button class="btn btn-outline-primary btn-sm" id="btnPreviewRmbg" type="button">Hapus BG (Preview)</button>
            <?php endif; ?>
            <button class="btn btn-outline-secondary btn-sm" id="btnResetFoto" type="button">Reset Foto</button>
            <div class="small text-muted">Setelah memilih foto, editor crop (3:4) muncul. Simpan hasil crop sebelum mengirim.</div>
          </div>
        </div>
      </div>

      <!-- hasil crop base64 dikirim di sini -->
      <input type="hidden" name="cropped_png" id="croppedPng">

      <div class="mt-4 d-flex gap-2">
        <button type="submit" class="btn btn-primary">Buat PDF KTM</button>
        <a class="btn btn-light" href="list_mahasiswa.php">Daftar Mahasiswa</a>
      </div>
    </div>
  </form>
</div>

<!-- Overlay submit -->
<div id="busyOverlay"><div class="box"><div class="spinner"></div><div><b>Sedang memproses PDF…</b><div class="small text-muted">Mohon tunggu</div></div></div></div>

<!-- Modal Crop -->
<div class="modal fade" id="cropModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Atur Crop Foto (Rasio 3:4)</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body">
        <div style="max-height:70vh"><img id="cropImg" style="max-width:100%; display:block;"></div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-light" data-bs-dismiss="modal">Batal</button>
        <button id="btnSaveCrop" class="btn btn-primary">Simpan Hasil Crop</button>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/cropperjs@1.6.2/dist/cropper.min.js"></script>
<script>
let cropper=null, originalDataUrl='';
const modal   = new bootstrap.Modal(document.getElementById('cropModal'));
const imgEl   = document.getElementById('cropImg');
const fileEl  = document.getElementById('photoFile');
const prevEl  = document.getElementById('photoPreview');
const hiddenEl= document.getElementById('croppedPng');
const btnPrev = document.getElementById('btnPreviewRmbg');
const btnReset= document.getElementById('btnResetFoto');

fileEl.addEventListener('change', () => {
  const f = fileEl.files && fileEl.files[0];
  if (!f) return;
  const url = URL.createObjectURL(f);
  imgEl.src = url;
  modal.show();
  modal._element.addEventListener('shown.bs.modal', () => {
    if (cropper) cropper.destroy();
    cropper = new Cropper(imgEl, {aspectRatio:3/4, viewMode:1, background:false, autoCropArea:1});
  }, {once:true});
});

document.getElementById('btnSaveCrop').addEventListener('click', () => {
  if (!cropper) return;
  const canvas = cropper.getCroppedCanvas({ width:900, height:1200 });
  canvas.toBlob((blob) => {
    const reader = new FileReader();
    reader.onload = () => {
      hiddenEl.value   = reader.result; // dataURL
      originalDataUrl  = reader.result; // simpan untuk reset preview
      prevEl.innerHTML = '';
      const img = new Image(); img.src = reader.result; prevEl.appendChild(img);
      modal.hide();
    };
    reader.readAsDataURL(blob);
  }, 'image/png');
});

// Preview remove.bg via proxy
if (btnPrev){
  btnPrev.addEventListener('click', async () => {
    if (!hiddenEl.value){ alert('Pilih & Simpan hasil crop dulu.'); return; }
    btnPrev.disabled = true; btnPrev.textContent = 'Tunggu...';
    try{
      const form = new FormData();
      form.append('image', hiddenEl.value);
      const res = await fetch('ajax_removebg.php', { method:'POST', body:form });
      const json = await res.json();
      if(json && json.ok){
        hiddenEl.value   = json.data_url;   // pakai hasil untuk submit
        prevEl.innerHTML = '';
        const img = new Image(); img.src = json.data_url; prevEl.appendChild(img);
        document.getElementById('remove_bg')?.setAttribute('checked','checked');
      }else{
        alert('Gagal remove background: ' + (json?.error || 'Unknown'));
      }
    }catch(e){ alert('Error: '+e); }
    finally{ btnPrev.disabled = false; btnPrev.textContent = 'Hapus BG (Preview)'; }
  });
}

// Reset ke hasil crop awal
btnReset.addEventListener('click', () => {
  if (!originalDataUrl){ return; }
  hiddenEl.value   = originalDataUrl;
  prevEl.innerHTML = '';
  const img = new Image(); img.src = originalDataUrl; prevEl.appendChild(img);
  const rb = document.getElementById('remove_bg'); if(rb) rb.checked = false;
});

// overlay submit
document.getElementById('ktmForm').addEventListener('submit', (ev) => {
  if (!hiddenEl.value && !(fileEl.files && fileEl.files.length)) {
    ev.preventDefault();
    alert('Silakan pilih foto lalu Simpan Hasil Crop.');
    return;
  }
  document.getElementById('busyOverlay').style.display='flex';
});
</script>
</body>
</html>
