<?php
// ==== Autoload & koneksi ====
require __DIR__ . '/vendor/autoload.php';   // dompdf + picqer
require __DIR__ . '/koneksi.php';
$CFG = require __DIR__ . '/config.php';

if (!class_exists(\Dompdf\Dompdf::class) || !class_exists(\Picqer\Barcode\BarcodeGeneratorPNG::class)) {
  http_response_code(500);
  echo "Dependensi belum siap.\n"
     . "Jalankan di folder ktm-app:\n"
     . "composer require dompdf/dompdf picqer/php-barcode-generator\n";
  exit;
}

use Dompdf\Dompdf;
use Dompdf\Options;

// ==== Helpers ====
function _ensure_dir($dir){ if(!is_dir($dir)) @mkdir($dir, 0775, true); }
function _file_to_data_uri($path){
  if (!is_file($path)) return '';
  $mime = mime_content_type($path) ?: 'application/octet-stream';
  return 'data:'.$mime.';base64,'.base64_encode(file_get_contents($path));
}
function _lower($s){ return function_exists('mb_strtolower') ? mb_strtolower($s,'UTF-8') : strtolower($s); }
function _map_front_bg($jurusan){
  $j = _lower(trim($jurusan));
  if (strpos($j,'teknologi') !== false || strpos($j,'ti') !== false)
    return __DIR__.'/assets/backs/back_template_ti.png';
  if (strpos($j,'akuntansi') !== false)
    return __DIR__.'/assets/backs/back_template_akuntansi.png';
  return __DIR__.'/assets/backs/back_template_manajemen.png';
}
function _sanitize_year($y){
  $y = preg_replace('/\D+/','',$y);
  return substr($y,0,4) ?: date('Y');
}
function remove_bg_if_requested($path, $wantRemove, $CFG){
  if (!$wantRemove || empty($path) || !is_file($path)) return;
  $prov = $CFG['remove_bg']['provider'] ?? 'rembg';
  $endpoint = rtrim($CFG['remove_bg']['endpoint'] ?? '', '/');
  $timeout  = (int)($CFG['remove_bg']['timeout'] ?? 60);
  if ($prov !== 'rembg' || !$endpoint) return; // hanya dukung rembg self-host di sini

  // kirim multipart file=...
  $ch = curl_init($endpoint);
  $cfile = new CURLFile($path, mime_content_type($path),'photo.png');
  $post = ['file' => $cfile];
  curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $post,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CONNECTTIMEOUT => 10,
    CURLOPT_TIMEOUT => $timeout,
    CURLOPT_SSL_VERIFYPEER => true,
  ]);
  $res = curl_exec($ch);
  $http= curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
  $err = curl_error($ch);
  curl_close($ch);

  if ($http === 200 && $res !== false) {
    // simpan hasil (PNG transparan)
    file_put_contents($path, $res);
  } else {
    error_log("removebg gagal: HTTP $http ".($err?:'')." endpoint=$endpoint");
  }
}

// ==== Ambil data dari form ====
$nama     = trim($_POST['nama'] ?? '');
$jenjang  = trim($_POST['jenjang'] ?? '');
$jurusan  = trim($_POST['jurusan'] ?? '');
$angkatan = _sanitize_year($_POST['angkatan'] ?? '');
$nim      = preg_replace('/\D+/', '', $_POST['nim'] ?? '');
$wantRemove = !empty($_POST['remove_bg']) && !empty(($CFG['remove_bg']['enabled'] ?? false));

if (!$nama || !$jenjang || !$jurusan || !$angkatan || !$nim) {
  http_response_code(400);
  echo "Data kurang lengkap.";
  exit;
}

// ==== Siapkan foto (pakai hasil crop base64 kalau ada) ====
$uploads = __DIR__ . '/uploads';
$origDir = $uploads . '/original';
$procDir = $uploads . '/processed';
_ensure_dir($origDir);
_ensure_dir($procDir);

// NOTE: nama field dari form adalah 'cropped_png'
$foto_data_b64  = $_POST['cropped_png'] ?? $_POST['foto_cropped'] ?? $_POST['foto_data'] ?? $_POST['photo_cropped'] ?? '';
$processed_path = '';

if ($foto_data_b64 && preg_match('#^data:image/(png|jpe?g);base64,#i', $foto_data_b64)) {
  $raw  = base64_decode(preg_replace('#^data:image/[^;]+;base64,#','', $foto_data_b64));
  $processed_path = $procDir . '/'. preg_replace('/\W+/', '', $nim) .'.png';
  file_put_contents($processed_path, $raw);
} elseif (!empty($_FILES['foto']['tmp_name'])) {
  // fallback: upload tanpa cropper -> crop 3:4 cepat
  $tmp = $_FILES['foto']['tmp_name'];
  $dst = $origDir . '/'. preg_replace('/\W+/', '', $nim) .'.jpg';
  move_uploaded_file($tmp, $dst);

  $img = @imagecreatefromstring(file_get_contents($dst));
  if ($img) {
    $w = imagesx($img); $h = imagesy($img);
    $targetRatio = 3/4; $curRatio = $w/$h;
    if ($curRatio > $targetRatio) { $newW=(int)round($h*$targetRatio); $x=(int)(($w-$newW)/2); $y=0; $cw=$newW; $ch=$h; }
    else { $newH=(int)round($w/$targetRatio); $x=0; $y=(int)(($h-$newH)/2); $cw=$w; $ch=$newH; }
    $crop = imagecreatetruecolor($cw,$ch);
    imagecopy($crop,$img,0,0,$x,$y,$cw,$ch);
    $processed_path = $procDir . '/'. preg_replace('/\W+/', '', $nim) .'.png';
    imagepng($crop,$processed_path,9);
    imagedestroy($crop); imagedestroy($img);
  }
}

if (!$processed_path || !is_file($processed_path)) {
  http_response_code(400);
  echo "Foto belum dipilih / gagal diproses.";
  exit;
}

// ==== Remove Background (opsional) ====
remove_bg_if_requested($processed_path, $wantRemove, $CFG);

// ==== Background & Barcode ====
$front_bg_path = _map_front_bg($jurusan);
$back_bg_path  = __DIR__ . '/assets/backs/back_template_belakang.png';

$barcodeGen  = new \Picqer\Barcode\BarcodeGeneratorPNG();
$barcodePng  = $barcodeGen->getBarcode($nim, $barcodeGen::TYPE_CODE_128, 2.1, 70);
$barcodeData = 'data:image/png;base64,' . base64_encode($barcodePng);

// ==== Simpan/Update ke DB (tabel mahasiswa) ====
// buat tabel jika belum ada (mengacu ke struktur yang kamu kirim)
$conn->query("CREATE TABLE IF NOT EXISTS mahasiswa (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nama VARCHAR(100) NOT NULL,
  jenjang VARCHAR(20) NOT NULL,
  jurusan VARCHAR(50) NOT NULL,
  angkatan YEAR NOT NULL,
  nim VARCHAR(30) NOT NULL,
  foto VARCHAR(255) NOT NULL,
  tanggal TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  UNIQUE KEY (nim)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

$relFoto = 'uploads/processed/'.preg_replace('/\W+/', '', $nim).'.png';
$stmt = $conn->prepare("INSERT INTO mahasiswa (nama,jenjang,jurusan,angkatan,nim,foto)
  VALUES (?,?,?,?,?,?)
  ON DUPLICATE KEY UPDATE
    nama=VALUES(nama),
    jenjang=VALUES(jenjang),
    jurusan=VALUES(jurusan),
    angkatan=VALUES(angkatan),
    foto=VALUES(foto)");
if ($stmt) {
  $stmt->bind_param('ssssss', $nama, $jenjang, $jurusan, $angkatan, $nim, $relFoto);
  if (!$stmt->execute()) {
    error_log('DB insert/update gagal: '.$stmt->error);
  }
  $stmt->close();
} else {
  error_log('Prepare gagal: '.$conn->error);
}

// ==== Kirim ke template ====
$V = [
  'nama'     => strtoupper($nama),
  'jenjang'  => $jenjang,
  'jurusan'  => $jurusan,
  'angkatan' => $angkatan,
  'nim'      => $nim,
  'frontBg'  => _file_to_data_uri($front_bg_path),
  'backBg'   => _file_to_data_uri($back_bg_path),
  'photo'    => _file_to_data_uri($processed_path),
  'barcode'  => $barcodeData,
];

ob_start();
extract($V, EXTR_SKIP);
require __DIR__ . '/templates/card_pdf.php';
$html = ob_get_clean();

$options = new Options();
$options->set('isRemoteEnabled', true);
$options->set('isHtml5ParserEnabled', true);
$dompdf = new Dompdf($options);

// 54x86 mm
$wpt = (54/25.4)*72;
$hpt = (86/25.4)*72;
$dompdf->setPaper([0,0,$wpt,$hpt], 'portrait');

$dompdf->loadHtml($html);
$dompdf->render();

// simpan juga ke folder output
$outDir = __DIR__ . '/output';
_ensure_dir($outDir);
$filePath = $outDir . '/ktm-' . preg_replace('/\W+/', '', $nim) . '.pdf';
file_put_contents($filePath, $dompdf->output());

// tampilkan inline
$dompdf->stream('ktm-'.$nim.'.pdf', ['Attachment' => false]);
exit;
