<?php
require __DIR__ . '/vendor/autoload.php';
require __DIR__ . '/koneksi.php';

use Dompdf\Dompdf;
use Dompdf\Options;

function _file_to_data_uri($p){ if(!is_file($p)) return ''; $m=mime_content_type($p)?:'application/octet-stream'; return 'data:'.$m.';base64,'.base64_encode(file_get_contents($p)); }
function _lower($s){ return function_exists('mb_strtolower') ? mb_strtolower($s,'UTF-8') : strtolower($s); }
function _map_front_bg($jur){
  $j=_lower(trim($jur));
  if (strpos($j,'teknologi')!==false || strpos($j,'ti')!==false) return __DIR__.'/assets/backs/back_template_ti.png';
  if (strpos($j,'akuntansi')!==false) return __DIR__.'/assets/backs/back_template_akuntansi.png';
  return __DIR__.'/assets/backs/back_template_manajemen.png';
}

$id = (int)($_GET['id'] ?? 0);
if(!$id){ http_response_code(400); exit('ID?'); }
$rw = $conn->query("SELECT * FROM mahasiswa WHERE id=$id")->fetch_assoc();
if(!$rw){ http_response_code(404); exit('Data tidak ditemukan'); }

$fotoPath = __DIR__ . '/' . ltrim($rw['foto'],'/');
$frontBg  = _file_to_data_uri(_map_front_bg($rw['jurusan']));
$backBg   = _file_to_data_uri(__DIR__ . '/assets/backs/back_template_belakang.png');
$photo    = _file_to_data_uri($fotoPath);

$gen = new \Picqer\Barcode\BarcodeGeneratorPNG();
$barcode = 'data:image/png;base64,' . base64_encode($gen->getBarcode($rw['nim'],$gen::TYPE_CODE_128,2.1,70));

$V = [
  'nama'=>strtoupper($rw['nama']),
  'jenjang'=>$rw['jenjang'],
  'jurusan'=>$rw['jurusan'],
  'angkatan'=>$rw['angkatan'],
  'nim'=>$rw['nim'],
  'frontBg'=>$frontBg, 'backBg'=>$backBg, 'photo'=>$photo, 'barcode'=>$barcode
];

ob_start(); extract($V,EXTR_SKIP); require __DIR__.'/templates/card_pdf.php'; $html=ob_get_clean();

$opt=new Options(); $opt->set('isRemoteEnabled',true); $opt->set('isHtml5ParserEnabled',true);
$pdf=new Dompdf($opt);
$wpt=(54/25.4)*72; $hpt=(86/25.4)*72;
$pdf->setPaper([0,0,$wpt,$hpt],'portrait');
$pdf->loadHtml($html); $pdf->render();
$pdf->stream('ktm-'.$rw['nim'].'.pdf',['Attachment'=>false]);
